<?php

class Pkli_Mods
{

    public function __construct()
    {

        add_filter('get_avatar', array('Pkli_Mods', 'override_user_photo'), 1, 5);
    }

    public static function override_user_photo($avatar, $id_or_email, $size, $default, $alt)
    {

        $li_options = get_option('pkli_basic_options');

        if ($li_options['li_override_profile_photo'] !== 'yes') {
            return;
        }

        $user = false;

        if (is_numeric($id_or_email)) {

            $id = (int) $id_or_email;
            $user = get_user_by('id', $id);

        } elseif (is_object($id_or_email)) {

            if (!empty($id_or_email->user_id)) {
                $id = (int) $id_or_email->user_id;
                $user = get_user_by('id', $id);
            }

        } else {
            $user = get_user_by('email', $id_or_email);
        }

        if ($user && is_object($user)) {

            $li_profile = get_user_meta($user->ID, 'pkli_linkedin_profile', true);

            if (empty($li_profile)) {
                return $avatar;
            }

            $li_profile_pic = $li_profile['profile_picture'];

            $avatar = "<img alt='{$alt}' src='{$li_profile_pic}' class='avatar avatar-{$size} photo' height='{$size}' width='{$size}' />";

        }

        return $avatar;

    }
}
