<?php

class PKLI_Settings
{

    private $options;

    public function __construct()
    {

        add_action('admin_menu', array($this, 'add_admin_menu'));
        add_action('admin_init', array($this, 'init_settings'));

        $this->options = get_option('pkli_basic_options');
        $this->options_buddypress = get_option('pkli_buddypress_options');
        $this->options_locked_content = get_option('pkli_locked_content_options');
    }

    public function add_admin_menu()
    {
        add_options_page('Integracja LinkedIn', 'Integracja LinkedIn', 'manage_options', 'linkedin_login_settings', array($this, 'pkli_options_page_display'));

    }

    public function pkli_options_page_display()
    {
        echo '<h2>' . __('Integracja LinkedIn - Ustawienia', 'linkedin-login') . '</h2>';

        $this->pkli_basic_options_section_callback();

        $active_tab = "general-options";
        if (isset($_GET["tab"])) {
            if ($_GET["tab"] == "buddypress-options" && class_exists('BuddyPress')) {
                $active_tab = "buddypress-options";
            } elseif ($_GET["tab"] == "locked-content-options") {
                $active_tab = "locked-content-options";
            }
        }
        ?>
        <h2 class="nav-tab-wrapper">
                <a href="?page=linkedin_login_settings&tab=general-options" class="nav-tab <?php if ($active_tab == 'general-options') {echo 'nav-tab-active';}?>"><?php _e('Główne', 'linkedin-login');?></a>
                <?php if (class_exists('BuddyPress')) {?>
                    <a href="?page=linkedin_login_settings&tab=buddypress-options" class="nav-tab <?php if ($active_tab == 'buddypress-options') {echo 'nav-tab-active';}?>"><?php _e('BuddyPress', 'linkedin-login');?></a>
                <?php }?>
                <a href="?page=linkedin_login_settings&tab=locked-content-options" class="nav-tab <?php if ($active_tab == 'locked-content-options') {echo 'nav-tab-active';}?>"><?php _e('Chroniona treść', 'linkedin-login');?></a>
        </h2>
        <form action='options.php' method='post'>

            <?php
if ($active_tab == 'general-options') {
            settings_fields('pkli_options_page');
            do_settings_sections('pkli_options_page');

        } elseif ($active_tab == 'buddypress-options') {

            echo "<div class='tab-buddypress-options'>";
            settings_fields('pkli_buddypress_options');
            do_settings_sections('pkli_options_buddypress_page');
            echo "</div>";

        } elseif ($active_tab = "locked-content-options") {

            echo "<div class='tab-locked-content-options'>";
            settings_fields('pkli_locked_content_options');
            do_settings_sections('pkli_options_locked_content_page');
            echo "</div>";
        }

        submit_button();
        ?>

        </form>
        <?php
}

    public function init_settings()
    {

        register_setting('pkli_buddypress_options', 'pkli_buddypress_options');
        add_settings_section('pkli_buddypress_options_section', '', '', 'pkli_options_buddypress_page');

        if (class_exists('BuddyPress')) {
            global $wpdb;

            $table_prof_fields = $wpdb->prefix . 'bp_xprofile_fields';
            $sql = "SELECT id, name FROM `{$table_prof_fields}` WHERE 1";
            $arr_names = $wpdb->get_results($sql);
            add_settings_field(
                'pkli_buddypress_options_section',
                __('', 'linkedin-login'),
                array($this, 'buddypress_fields_match'),
                'pkli_options_buddypress_page',
                'pkli_buddypress_options_section',
                array('field_name' => 'li_buddypress_fields', 'args' => $arr_names)
            );
        }

        register_setting('pkli_options_page', 'pkli_basic_options');
        add_settings_section('pkli_general_options_section', '', '', 'pkli_options_page');

        add_settings_field(
            'li_api_key',
            __('LinkedIn API Key', 'linkedin-login'),
            array($this, 'text_field_display'),
            'pkli_options_page',
            'pkli_general_options_section',
            array('field_name' => 'li_api_key',
                'field_description' => 'Klucz można zdobyć tutaj <a href="https://www.linkedin.com/secure/developer" target="_blank">LinkedIn Developer Portal</a>.',
                'field_help' => 'help text goes here')
        );

        add_settings_field(
            'li_secret_key',
            __('LinkedIn API Secret', 'linkedin-login'),
            array($this, 'text_field_display'),
            'pkli_options_page',
            'pkli_general_options_section',
            array('field_name' => 'li_secret_key',
                'field_description' => 'Jest to kolejny klucz, który można znaleźć również podczas tworzenia aplikacji. Wklej tutaj.')
        );

        add_settings_field(
            'li_redirect_url',
            __('Przekierowanie po logowaniu', 'linkedin-login'),
            array($this, 'text_field_display'),
            'pkli_options_page',
            'pkli_general_options_section',
            array('field_name' => 'li_redirect_url',
                'field_description' => 'Strona, do której ma zostać przekierowany użytkownik po zalogowaniu. Jeśli pole pozostawisz puste, przekieruje na stronę kokpitu.')

        );

        add_settings_field(
            'li_registration_redirect_url',
            __('Przekierowanie po rejestracji', 'linkedin-login'),
            array($this, 'text_field_display'),
            'pkli_options_page',
            'pkli_general_options_section',
            array('field_name' => 'li_registration_redirect_url',
                'field_description' => 'Użytkownicy są przekierowywani na ten adres URL podczas rejestracji za pośrednictwem konta LinkedIn. Jest to przydatne, jeśli chcesz pokazać im jednorazową wiadomość powitalną po rejestracji. Jeśli pole pozostawisz puste, przekieruje na stronę kokpitu.')
        );

        add_settings_field(
            'li_cancel_redirect_url',
            __('Przekierowanie po anulowaniu', 'linkedin-login'),
            array($this, 'text_field_display'),
            'pkli_options_page',
            'pkli_general_options_section',
            array('field_name' => 'li_cancel_redirect_url',
                'field_description' => 'Użytkownicy są przekierowywani na ten adres URL po kliknięciu przycisku Anuluj na stronie uwierzytelniania LinkedIn. Jest to przydatne, jeśli chcesz pokazać im inną opcję, jeśli z jakiegoś powodu nie chcą się zalogować na swoje konto LinkedIn. Jeśli pole pozostawisz puste, przekieruje na stronę kokpitu.')
        );

        require_once PKLI_PATH . '/includes/lib/class-pkli-scopes.php';

        add_settings_field(
            'li_list_scopes',
            __('Dodatkowe pola', 'linkedin-login'),
            array($this, 'checkbox_field_display'),
            'pkli_options_page',
            'pkli_general_options_section',
            array('field_name' => 'li_list_scopes',
                'field_description' => 'Wybierz dodatkowe potrzebne pola LinkedIn. Z tej opcji powinni korzystać wyłącznie programiści, którzy chcą rozszerzyć wtyczkę.',
                'args' => array(
                    'values' => array(
                        Pkli_Scopes::READ_BASIC_PROFILE => 'Basic profile',
                        Pkli_Scopes::READ_EMAIL_ADDRESS => 'Email address',

                    ),
                    'other' => array('disabled' => array(Pkli_Scopes::READ_BASIC_PROFILE, Pkli_Scopes::READ_EMAIL_ADDRESS)),
                ),
            )
        );

        add_settings_field(
            'li_auto_profile_update',
            __('Pobierać dane profilu LinkedIn za każdym razem?', 'linkedin-login'),
            array($this, 'select_field_display'),
            'pkli_options_page',
            'pkli_general_options_section',
            array('field_name' => 'li_auto_profile_update',
                'field_description' => 'Ta opcja umożliwia pobranie danych użytkowników po raz pierwszy, przy rejestracji, ale nie zastępowanie wszystkich ich informacji za każdym razem, gdy logują się za pomocą przycisku z linkiem. Jest to przydatne, jeśli użytkownicy spędzają czas na tworzeniu profilu niestandardowego, a następnie używają przycisku logowania z przyciskiem Linkedin. Wyłącz to, jeśli nie chcesz, aby ich informacje zostały zastąpione')
        );

        add_settings_field(
            'li_override_profile_photo',
            __("Zastąpić zdjęcie profilowe użytkownika?", 'linkedin-login'),
            array($this, 'select_field_display'),
            'pkli_options_page',
            'pkli_general_options_section',
            array('field_name' => 'li_override_profile_photo',
                'field_description' => 'Po włączeniu tej opcji, pobiera zdjęcie profilowe użytkownika z LinkedIn i zastępuje domyślne zdjęcie profilowe użytkownika gravatar.com używane przez WordPress. Jeśli wtyczka jest skonfigurowana do pobierania nowych danych profilu przy każdym logowaniu, zdjęcie profilowe również zostanie odzyskane.')
        );

        add_settings_field(
            'li_logged_in_message',
            __('Wiadomość dla zalogowanych', 'linkedin-login'),
            array($this, 'text_area_display'),
            'pkli_options_page',
            'pkli_general_options_section',
            array('field_name' => 'li_logged_in_message',
                'field_description' => 'Zamiast przycisku logowania wprowadź wiadomość, którą chcesz wyświetlić dla zalogowanych użytkowników. Jeśli pozostawisz pole puste, przycisk będzie ukryty i nie wyświetli się żaden komunikat.',
                'args' => array(
                    'parent' => 'pkli_basic_options',
                ),
            )
        );

        add_settings_field(
            'li_keep_user_logged_in',
            __("Nie wylogowuj użytkownika?", 'linkedin-login'),
            array($this, 'select_field_display'),
            'pkli_options_page',
            'pkli_general_options_section',
            array('field_name' => 'li_keep_user_logged_in',
                'field_description' => 'Czy użytkownik powinien się logować za każdym razem, czy pamiętać jego dane po zalogowaniu przez LinkedIn?')
        );

        register_setting('pkli_locked_content_options', 'pkli_locked_content_options');
        add_settings_section('pkli_locked_content_options_section', '', '', 'pkli_options_locked_content_page');

        add_settings_field(
            'pkli_locked_content_options_section',
            __('Domyślna wiadomość', 'linkedin-login'),
            array($this, 'text_area_display'),
            'pkli_options_locked_content_page',
            'pkli_locked_content_options_section',
            array('field_name' => 'li_locked_content_message',
                'field_description' => '',
                'args' => array(
                    'parent' => 'pkli_locked_content_options',
                ),
            )
        );
    }

    public function text_field_display($field_options)
    {

        // Get the text field name
        $field_name = $field_options['field_name'];
        ?>
        <input type='text' name='pkli_basic_options[<?php echo $field_name; ?>]' value='<?php echo $this->get_field_value($field_name) ?>'>
        <p class="description"><?php echo isset($field_options['field_description']) ? $field_options['field_description'] : ''; ?></p>
        <?php

    }

    public function text_area_display($field_options)
    {
        $field_name = $field_options['field_name'];
        $arg_parent = !empty($field_options['args']['parent']) ? $field_options['args']['parent'] : 'pkli_basic_options';
        $stored_value = $arg_parent == 'pkli_basic_options' ? $this->get_field_value($field_name) : (isset($this->options_locked_content[$field_name]) ? $this->options_locked_content[$field_name] : '');
        ?>
        <textarea cols='40' rows='5' name='<?php echo $arg_parent; ?>[<?php echo $field_name; ?>]'><?php echo $stored_value; ?></textarea>
        <p class="description"><?php echo isset($field_options['field_description']) ? $field_options['field_description'] : ''; ?></p>
        <?php

    }

    private function get_field_value($field_name)
    {

        return isset($this->options[$field_name]) ? $this->options[$field_name] : '';

    }

    public function select_field_display($field_options)
    {

        $field_name = $field_options['field_name'];
        $field_value = $this->get_field_value($field_name);
        ?>
        <select name='pkli_basic_options[<?php echo $field_name; ?>]'>
            <option value='yes' <?php selected($field_value, 'yes');?>>Tak</option>
            <option value='no' <?php selected($field_value, 'no');?>>Nie</option>
        </select>
        <p class="description"><?php echo isset($field_options['field_description']) ? $field_options['field_description'] : ''; ?></p>
        <?php
}

    public function checkbox_field_display($field_options)
    {
        $field_name = $field_options['field_name'];
        $field_value = $this->get_field_value($field_name);
        $field_value = is_array($field_value) ? $field_value : array();

        $arg_values = $field_options['args']['values'];
        $other = $field_options['args']['other'];
        $disabled = !empty($other['disabled']) ? $other['disabled'] : array();
        $field_value = array_unique(array_merge($field_value, $disabled));
        if (!empty($arg_values)) {
            foreach ($arg_values as $key => $value) {?>
                        <p><input type="checkbox" name="pkli_basic_options[<?php echo $field_name; ?>][]" value="<?php echo $key; ?>" <?php echo in_array($key, $field_value) ? 'checked' : ''; ?> <?php echo in_array($key, $disabled) ? 'disabled' : ''; ?>>
                        <label><?php echo $value; ?></label></p>
            <?php }
        }
        ?>
        <p class="description"><?php echo isset($field_options['field_description']) ? $field_options['field_description'] : ''; ?></p>
        <?php
}

    public function buddypress_fields_match($field_options)
    {
        $field_name = $field_options['field_name'];
        $args = $field_options['args'];

        $stored_values = isset($this->options_buddypress[$field_name]) ? $this->options_buddypress[$field_name] : '';
        $stored_values = is_array($stored_values) ? $stored_values : array();

        $ln_fields = array(
            'first-name' => 'First Name',
            'last-name' => 'Last Name',
            'headline' => 'Headline',
            'positions' => 'Positions',
            'picture-url' => 'Picture URL',
        );
        ?>
        <h2><?php _e('Map LinkedIn to BuddyPress fields', 'linkedin-login');?></h2>
        <h3><?php _e('Choose which LinkedIn fields correspond to your BuddyPress custom fields', 'linkedin-login');?></h3>
        <table class='buddypress_table'>
            <tr><th><?php _e('LinkedIn', 'linkedin-login');?></th><th><?php _e('Buddypress', 'linkedin-login');?></th></tr>
            <?php
foreach ($ln_fields as $ln_key => $ln_value) {
            echo '<tr><td>' . $ln_value . '</td><td>' . $this->buddypress_list_fields($args, $field_name, $ln_key, $stored_values) . '</td></tr>';
        }
        ?>
        </table>
    <?php
}

    private function buddypress_list_fields($args, $field_name, $field_key, $stored_values)
    {
        if (empty($args)) {
            return '';
        }
        $html = '<select name="pkli_buddypress_options[' . $field_name . '][' . $field_key . ']">';
        if (!empty($args)) {
            $selected = (isset($stored_values[$field_key]) && $stored_values[$field_key] == 'not_map') ? 'selected' : '';
            $html .= '<option value="not_map" ' . $selected . '>' . __('Do Not Map', 'linkedin-login') . '</option>';
            foreach ($args as $key => $value) {
                $selected = (isset($stored_values[$field_key]) && $stored_values[$field_key] == $value->id) ? 'selected' : '';
                $html .= '<option value="' . $value->id . '" ' . $selected . '>' . $value->name . '</option>';
            }
        }
        $html .= '</select>';
        return $html;
    }

    public function pkli_basic_options_section_callback()
    {

        

    }

}