function lightOrDark(color) {

    // Variables for red, green, blue values
    var r, g, b, hsp;
    
    // Check the format of the color, HEX or RGB?
    if (color.match(/^rgb/)) {

        // If HEX --> store the red, green, blue values in separate variables
        color = color.match(/^rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+(?:\.\d+)?))?\)$/);
        
        r = color[1];
        g = color[2];
        b = color[3];
    } 
    else {
        
        // If RGB --> Convert it to HEX: http://gist.github.com/983661
        color = +("0x" + color.slice(1).replace( 
        color.length < 5 && /./g, '$&$&'));

        r = color >> 16;
        g = color >> 8 & 255;
        b = color & 255;
    }
    
    // HSP (Highly Sensitive Poo) equation from http://alienryderflex.com/hsp.html
    hsp = Math.sqrt(
    0.299 * (r * r) +
    0.587 * (g * g) +
    0.114 * (b * b)
    );

    // Using the HSP value, determine whether the color is light or dark
    if (hsp>200) {

        return '#000';
    } 
    else {

        return '#fff';
    }
}

jQuery(document).ready(function($) {
    'use strict';

    $('.letter-avatar').each(function() {
        var color = $(this).css('background-color');
        
        var fontColor = lightOrDark(color);

        $(this).css('color', fontColor);
    })

    // iOS fix
    if(/iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream){
        document.querySelector('meta[name=viewport]').setAttribute(
            'content',
            'initial-scale=1.0001, minimum-scale=1.0001, maximum-scale=1.0001, user-scalable=no'
        );
    }

    if( $('#listing_details-2').length > 0 ) {
        var width = $('#secondary').width();
        $('#listing_details-2 .inner-wrapper-sticky').width(width);
        $(window).trigger('resize');

        var sidebar = new StickySidebar('#sticky', {
            containerSelector: '#secondary',
            // innerWrapperSelector: '.widget-inner',
            topSpacing: 150,
            bottomSpacing: 50
        });
    }

    /**
     * Action Bar
     */
    // Switch the body classes
    $('.action-bar-chapter a').on('click', function(e) {
       e.preventDefault();

       $(this).closest('ul').find('a').removeClass('active');
       $(this).closest('ul').find('a').each(function() {
           $('body').removeClass($(this).attr('data-action'));
       });
       $('body').addClass($(this).attr('data-action'));
       $(this).addClass('active');
    });

    // Change color combination
    $('.action-bar-chapter table a').on('click', function(e) {
        e.preventDefault();
        $(this).closest('table').find('a').removeClass('active');
        $(this).addClass('active');

        var uri = $(this).attr('href');
        $('#superlist-css').attr('href', uri);
    });

    // Hide/Show
    $('.action-bar-title').on('click', function(e) {
        $('.action-bar-content').toggleClass('open');
    });

    /**
     * Tabs
     */
    $('.listing-categories-tabs a').on('click', function(e) {
        e.preventDefault();
        $(this).tab('show');
    });

    /**
     * Share listing
     */
    $('.share-listing').on('click', function(e) {
        e.preventDefault();
        var modalInner = $(this).next('.modal-inner').clone();
        $('.modal-screen').addClass('open');
        $('.modal-main').html(modalInner);
    });

    /**
     * Modal
     */
    $('.modal-close').on('click', function() {
        $(this).closest('.modal-screen').removeClass('open');
        $('.modal-main').empty();
    });

    $('body').on('keyup', function(e) {
        if ($('.modal-screen').hasClass('open')) {
            if (e.keyCode == 27) {
                $('.modal-screen').removeClass('open');
                $('.modal-main').empty();
            }
        }
    });

    /**
     * Detail menu
     */
    var listingDetailMenu = $('.listing-detail-menu');

    if (listingDetailMenu.length) {
        $('.listing-detail-section').each(function() {
            var title = $('h2', $(this)).first().html();

            if (title === undefined) {
                title = $('h3', $(this)).first().html();
            }

            var id = $(this).attr('id');
            $('ul', listingDetailMenu).append('<li class="' + id  + '"><a href="#' + id + '">' + title + '</a></li>');
        });

        /**
         * Listing menu scroll
         */
        $('.listing-detail-menu a').click(function(e){
            e.preventDefault();

            var id = $(this).attr('href');

            $.scrollTo(id, 1200, {
                axis: 'y',
                offset: -160
            });
        });

        /**
         * Listing menu affix
         */
        if ($('.listing-detail-menu').length !== 0) {
            var height = $('.listing-detail-menu').offset().top;

            if ($('#wpadminbar').height() != null) {
                height -= $('#wpadminbar').height();
            }

            if ($('.header-sticky .header-wrapper').height() != null) {
                height -= 60;
            }

            $('.listing-detail-menu').affix({
                offset: {
                    top: height
                }
            });
        }

        /**
         * Scroll spy
         */
        $('body').scrollspy({
            target: '.listing-detail-menu',
            offset: 160
        });
    }


    /**
     * Detail Price
     */
    var listingDetailPrice = $('.detail-banner-right');

    if (listingDetailPrice.length) {
        var height = $('.detail-banner-right').offset().top;

        if ($('#wpadminbar').height() != null) {
            height -= $('#wpadminbar').height();
        }

        if ($('.header-sticky .header-wrapper').height() != null) {
            height -= 60;
        }

        var wWidth = $(window).width();
        if(wWidth > 767) {
            $('.detail-banner-right').affix({
                offset: {
                    top: height
                }
            });
        }
    }

    // Sticky header
    var isMobile = window.matchMedia("only screen and (max-width: 760px)");

    if (!isMobile.matches) {
        $('.header-sticky .header-wrapper').affix({
            offset: {
                top: 200
            }
        });
    }

    /**
     * Header Action
     */
    $('.header-action').on('click', function(e) {
        e.preventDefault();
        $('.header-post-types').toggleClass('open');
        $('.header-action').toggleClass('open');
    });

    /**
     * Bootstrap Select
     */
    $('select').each(function() {
        if (!$(this).parents('.cmb-repeatable-group').length) {
            $(this).selectpicker({
                noneSelectedText: $(this).data('empty-label'),
                template: {
                    caret: '<i class="fa fa-chevron-down"></i>'
                }
            });
        }
    });

    $('select').on('change', function () {
        if (!$(this).parents('.cmb-repeatable-group').length) {
            $(this).selectpicker('refresh');
        }
    });

    //$('select:not(.cmb2_select)').selectpicker({
    //    noneSelectedText: $(this).data('empty-label'), // does not work
    //    template: {
    //        caret: '<i class="fa fa-chevron-down"></i>'
    //    }
    //});

    /**
     * Background image
     */
    $('*[data-background-image]').each(function() {
        $(this).css({
            'background-image': 'url(' + $(this).data('background-image') + ')'
        });
    });

    /**
     * Bootstrap Tooltip
     */
    $('[data-toggle="tooltip"]').tooltip({
        trigger: 'hover'
    });

    /**
     * Simple map
     */
    var simple_map = $( '#simple-map' );
    if (simple_map.length) {
        var style = simple_map.data( 'styles' );

        simple_map.google_map({
            center: {
                latitude: simple_map.data( 'latitude' ),
                longitude: simple_map.data( 'longitude' )
            },
            zoom: simple_map.data( 'zoom' ),
            zoomControl: true,
            styles: style,
            transparentMarkerImage: simple_map.data( 'transparent-marker-image' ),
            marker: {
                height: 38,
                width: 24
            },
            markers: [{
                latitude: simple_map.data( 'latitude' ),
                longitude: simple_map.data( 'longitude' ),
                marker_content: '<div class="simple-marker"></div>'
            }]
        });
    }

    /**
     * Listing banner map
     */
    var banner_map = $( '#banner-map' );
    if (banner_map.length) {
        var mapType;
        var markerContent;
        var marker = false;
        var markers = [];

        switch(banner_map.data( 'map-type' )) {
            case 'ROADMAP':
                mapType = google.maps.MapTypeId.ROADMAP;
                markerContent = '<div class="simple-marker"></div>';
                break;
            case 'HYBRID':
                mapType = google.maps.MapTypeId.HYBRID;
                markerContent = '<div class="simple-marker-primary"></div>';
                break;
            default:
                mapType = google.maps.MapTypeId.SATELLITE;
                markerContent = '<div class="simple-marker-primary"></div>';
        }

        if (banner_map.data( 'marker' )) {
            marker = {
                height: 38,
                width: 24
            };

            markers = [{
                latitude: banner_map.data( 'latitude' ),
                longitude: banner_map.data( 'longitude' ),
                marker_content: markerContent
            }]
        }

        banner_map.google_map({
            center: {
                latitude: banner_map.data( 'latitude' ),
                longitude: banner_map.data( 'longitude' )
            },
            zoom: banner_map.data( 'zoom' ),
            zoomControl: true,
            rotateControl: false,
            mapTypeId: mapType,
            tilt: 45,
            transparentMarkerImage: banner_map.data( 'transparent-marker-image' ),
            marker: marker,
            markers: markers
        });
    }

    /**
     * Listing Banner Detail Street View
     */
    streetViewInit('banner-street-view');
    streetViewInit('banner-inside-view');

    function streetViewInit(banner_street_view_id) {
        var banner_street_view = $('#' + banner_street_view_id);

        if (banner_street_view.length) {
            new google.maps.StreetViewPanorama(document.getElementById(banner_street_view_id), {
                    position: {
                        lat: banner_street_view.data( 'latitude' ),
                        lng: banner_street_view.data( 'longitude' )
                    },
                    pov: {
                        heading: banner_street_view.data( 'heading' ),
                        pitch: banner_street_view.data( 'pitch' )
                    },
                    zoom: banner_street_view.data( 'zoom' ),
                    linksControl: false,
                    panControl: false,
                    scrollwheel: false,
                    addressControl: false,
                    visible: true
                }
            );
        }
    }

    /**
     * Detail gallery
     */
    var listingGallery = $('.listing-detail-gallery');
    var listingGalleryPreview = $('.listing-detail-gallery-preview-inner');
    var listingGalleryPreviewCount = listingGalleryPreview.data('count');
    var listingGalleryPreviewItems = 7;

    if (listingGallery.length != 0) {
        var loop = true;

        if (listingGallery.length === 1) {
            loop = false;
        }

        listingGallery.owlCarousel({
            items: 1,
            loop: loop,
            autoHeight: true,
            autoplay: true,
            autoplayTimeout:5000,
            smartSpeed: 700,
            navText: ['<i class="fa fa-chevron-left"></i>', '<i class="fa fa-chevron-right"></i>']
        });
    }

    if (listingGalleryPreview.length != 0) {
        listingGalleryPreview.owlCarousel({
            items: listingGalleryPreviewItems,
            nav: (listingGalleryPreviewCount > listingGalleryPreviewItems),
            navText: ['<i class="fa fa-chevron-left"></i>', '<i class="fa fa-chevron-right"></i>']
        });
    }

    $('.listing-detail-gallery-preview-inner .owl-item:first').addClass('highlighted');

    listingGallery.on('changed.owl.carousel', function(event) {
        var currentIndex = event.item.index - 0; // bug because of "loop: true";
        var firstActiveIndex = $('.listing-detail-gallery-preview-inner .owl-item.active:first').children().data('item-id');
        var lastActiveIndex = $('.listing-detail-gallery-preview-inner .owl-item.active:last').children().data('item-id');

        if ( currentIndex == event.item.count ) {
            currentIndex = 0;
        }

        // Highlight current item
        $('.listing-detail-gallery-preview-inner .owl-item.highlighted').removeClass('highlighted');
        $('.listing-detail-gallery-preview-inner .owl-item:eq(' + currentIndex + ')').addClass('highlighted');

        // Move preview if it is necessary
        if (firstActiveIndex >= currentIndex) {
            for (var i = 0; i <= ( firstActiveIndex - currentIndex ); i++) {
                listingGalleryPreview.trigger('prev.owl.carousel');
            }
        } else if (lastActiveIndex <= currentIndex) {
            for (var i = 0; i <= ( currentIndex - lastActiveIndex ); i++) {
                listingGalleryPreview.trigger('next.owl.carousel');
            }
        }
    });

    // Show in gallery image from preview
    $('.listing-detail-gallery-preview-inner .owl-item').click(function(){
        var itemIndex = $(this).children().data('item-id');
        listingGallery.trigger('to.owl.carousel', [itemIndex, 300]);
    });

    $('.listing-detail-gallery').on('click', function() {
        listingGallery.trigger('stop.owl.autoplay');
    });

    /**
     * Colorbox
     */
    $('.listing-detail-gallery a').colorbox({
        ref: 'listing-gallery',
        maxHeight: '90%',
        maxWidth: '85%'
    });

    $('.compare-image a').colorbox({
        // ref: 'compare-gallery',
        maxHeight: '90%',
        maxWidth: '85%'
    });

    /**
     * Listing Detail Bookmark & Like
     */
    $(".detail-banner-btn.bookmark").click(function(){
        $(this).toggleClass("marked");

        var span = $(this).children("span");
        var toggleText = span.data("toggle");
        span.data("toggle", span.text());
        span.text(toggleText);
    });

    /**
     * Social Login
     */
    var title;
    $('.wp-social-login-provider').each(function(){
        title = $(this).attr('title');
        $(this).text(title);
    });

    /**
     * Responsive menu
     */
    function responsiveMenu() {
        var parent_menu = $('.header-nav-primary .menu-item-has-children');

        parent_menu.on('hover', function(e) {
            e.preventDefault();
        });

        parent_menu.on('click', function(e) {
            if (!$(this).hasClass('touched')) {
                e.preventDefault();
                $(this).closest('ul').find('> li').removeClass('touched');
                $(this).toggleClass('touched');
            }
        })
    }

    $(window).resize(function() {
        if ($(window).width() < 768) {
            responsiveMenu();
        }
    });

    if ($(window).width() < 768) {
        responsiveMenu();
    }

    /**
     * Masonry blog
     */
    if ( $('.content .post-masonry').length > 0 ) {
        $('.content').masonry({
            itemSelector: '.post-masonry'
        });
    }

    if( $('#cmb2-metabox-listing_program_funkcjonalnosci').length > 0 ) {
        if( $('#filter_cats').length > 0 ) {
            var cat_ids = $('#filter_cats').text();
            var array = cat_ids.split(',');

            var cat_names = $('#filter_cats_names').text();
            var array2 = cat_names.split(',');

            $('ul.cmb2-checkbox-list li').each(function() {
                var kategoria = $(this).find('input').attr('data-category');
                var fields = kategoria.split('-');

                if( !array.includes(fields[1]) ) {
                    $(this).hide();
                }
            });

            $("ul.cmb2-checkbox-list li").sort(sort_li).appendTo('ul.cmb2-checkbox-list');

            function sort_li(a, b) {
                return ($(b).find('input').data('category')) < ($(a).find('input').data('category')) ? 1 : -1;
            }

            var i;
            for (i = 0; i < array.length; ++i) {
                $("input.cmb2-option").filter(function() {
                  return $(this).data("category") == 'category-'+array[i];
                }).first().parent('li').before('</ul><h3>'+array2[i]+'</h3><ul class="cmb2-checkbox-list cmb2-list">')
            };
        }
    }

    if( $('#pros').length > 0 ) {
        $('#pros').summernote({
            airMode: true
        });
    }

    if( $('#cons').length > 0 ) {
        $('#cons').summernote({
            airMode: true
        });
    }

    if( $('#comment').length > 0 ) {
        $('#comment').summernote({
            airMode: true
        });
    }
});

! function(name, definition) {
    if (typeof module != 'undefined') module.exports = definition()
    else if (typeof define == 'function' && typeof define.amd == 'object') define(definition)
    else this[name] = definition()
}('domready', function() {
    var fns = [],
        listener, doc = document,
        hack = doc.documentElement.doScroll,
        domContentLoaded = 'DOMContentLoaded',
        loaded = (hack ? /^loaded|^c/ : /^loaded|^i|^c/).test(doc.readyState)
    if (!loaded) doc.addEventListener(domContentLoaded, listener = function() {
        doc.removeEventListener(domContentLoaded, listener)
        loaded = 1
        while (listener = fns.shift()) listener()
    })
    return function(fn) {
        loaded ? setTimeout(fn, 0) : fns.push(fn)
    }
});

domready(function() {
    if( $('#compare-sticky-header').length > 0 ) {
        var viewPortHeight = $(this).innerHeight();
        setFooterHeight();
        var scroll = function() {
            var currentHeight = $(window).scrollTop();
            if ($(this).scrollTop() >= 350 && (currentHeight + viewPortHeight < footerHeight) && !$('#primary').is(':hidden')) {
                $('#compare-sticky-header').slideDown();
                $('#compare-sticky-header').css('top', '0px !important');
                $('#compare-sticky-header').css('width', $('#primary').width());
            } else {
                $('#compare-sticky-header').slideUp();
            }
        };
        scroll();
        $(window).on('scroll resize', function() {
            scroll();
        });
    }

    if( $('#sticky').length > 0 ) {
        window.dispatchEvent(new Event('resize'));
    }
});

function setFooterHeight() {
    footerHeight = $('.footer-btn').offset().top + 100;
}