<?php
/**
 * The template for displaying page
 *
 * @package Superlist
 * @since Superlist 1.0.0
 */

get_header(); 
$value = get_query_var('id');
$_GET['id'] = $value;
$program = get_page_by_path($_GET['id'],OBJECT,'program');

$logo = get_post_meta($program->ID, 'listing_logo', true);
?>

    <div class="row">
        <div class="col-sm-8 col-lg-9">
            <div id="primary">
	            <div class="document-title">
                <?php echo wp_kses( do_shortcode( '[inventor_breadcrumb]' ), wp_kses_allowed_html( 'post' ) ); ?>

                <div id="alternative">
                    <div class="alt-image">
                        <img src="<?php echo $logo;?>">
                    </div>
                    <div class="alt-desc">
                        <h1><?php echo $program->post_title;?> - alternatywa</h1>
                        <div class="alt-meta">
                            <div class="alt-rating">
                                <?php do_action( 'inventor_listing_content', $program->ID, 'row' ); ?>
                            </div>
                            <div class="alt-price">
                                <dt>Cena</dt>
                                <dd><?php $price = Inventor_Price::get_price( $program->ID ); if(ContainsNumbers($price)) echo $price; else echo '-'; ?></dd>
                            </div>
                        </div>
                        <div class="actions">
                            <a href="<?php the_permalink( $program->ID );?>" class="btn btn-primary">Czytaj więcej</a> <a href="<?php echo get_post_meta($program->ID, 'listing_website', true);?>" target="_blank" class="btn btn-blue">Strona WWW</a>
                        </div>
                        <p>Poznaj listę alternatyw <?php echo $program->post_title;?> w <?php echo date('Y');?> roku</p>
                        <p>Porównaj alternatywne programy w łatwej do przeglądania tabeli i sprawdź opinie obecnych i byłych klientów. Zobacz, które rozwiązanie oferuje lepsze funkcjonalności lub niższą cenę.</p>
                    </div>
                </div>

                <?php $description = term_description(); ?>
                <?php if ( ! empty( $description ) ) : ?>
                    <?php echo wp_kses( $description, wp_kses_allowed_html( 'post' ) ); ?>
                <?php endif; ?>

                <?php if( is_tax('integracje') ) { 
                    $term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
                ?>
                    <p>Sprawdź aplikacje zintegrowane z <?php echo $term->name;?> i stwórz swój własny zestaw narzędzi, najbardziej optymalny dla Twojej organizacji.</p>
                <?php } ?>
            </div><!-- /.document-title -->

            <div class="sidebar" id="altTitle">
                <div class="widget">
                    <h2 class="widgettitle">Lista alternatyw</h2>
                </div>
            </div>

            <?php dynamic_sidebar( 'content-bottom' ); ?>

            </div><!-- /#primary -->
        </div><!-- /.col-* -->
        <div class="col-sm-4 col-lg-3">
            <div id="secondary" class="secondary sidebar">
                <div id="categories-8" class="widget widget_categories">
                    <h2 class="widgettitle">Porównaj <?php echo $program->post_title;?> z...</h2>
                    <?php 
                        $custom_terms = wp_get_post_terms($program->ID, 'listing_categories');
                        $tax_query = array();

                        if( count( $custom_terms ) > 1 )
                            $tax_query['relation'] = 'OR' ;

                        foreach( $custom_terms as $custom_term ) {
                            $tax_query[] = array(
                                'taxonomy' => 'listing_categories',
                                'field' => 'slug',
                                'terms' => $custom_term->slug,
                            );
                        };

                        $term_list = wp_get_post_terms($program->ID, 'listing_categories', array("fields" => "ids"));
                        $args = array( 
                            'posts_per_page'  => -1, 
                            'post__not_in' => array( $program->ID),
                            'post_type' => 'program',
                            'tax_query' => array(
                                array(
                                    'taxonomy' => 'listing_categories',
                                    'field'    => 'term_id',
                                    'terms'    => $term_list,
                                    'operator' => 'IN',
                                ),
                            ),
                            'orderby' => array( 
                                'meta_value_num' => 'DESC', 
                               'title'      => 'ASC', 
                               
                            ), 
                            'meta_key' => 'inventor_reviews_post_total_rating',
                            'order' => 'DESC'
                        );

                        $loop = new WP_Query($args);

                        if( $loop->have_posts() ) {
                            echo '<ul id="comapreWith">';
                            while( $loop->have_posts() ) : $loop->the_post();
                                $logo = get_post_meta($post->ID, 'listing_logo', true);
                                echo '<li><a href="'.get_bloginfo('url').'/porownaj/'.$program->post_name.'-vs-'.$post->post_name.'"><img src="'.$logo.'">'.$program->post_title.' vs '.get_the_title().'</a></li>';
                            endwhile;
                            echo '</ul>';
                        }
                        wp_reset_query();
                    ?>
                </div>
            </div>
        </div>
    </div><!-- /.row -->

<?php get_footer(); ?>
