<?php
/*
Template Name: Search Page
*/

get_header(); 

$programy = search_by_title( $_GET['q'] );
$kategorie = search_by_category( $_GET['q'] );
?>

<div class="row">
    <div class="<?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?>col-sm-8 col-lg-9<?php else : ?>col-sm-12<?php endif; ?>">
        <div id="primary">
            <?php // get_template_part( 'templates/document-title' ); ?>

            <?php dynamic_sidebar( 'content-top' ); ?>

                    <div class="content">

                    <?php 
                        if( !empty($kategorie) ) {
                            echo '<div class="document-title"><h1>Kategorie</h1></div>';
                            foreach( $kategorie as $kategoria ) {
                                $term = get_term_by( 'id', $kategoria, 'listing_categories' ); ?>
                                <div class="listing-row ">
                                    <div class="listing-row-body">
                                        <h2 class="listing-row-title"><a href="<?php echo get_term_link( $term );?>"><?php echo $term->name;?></a></h2>
                                        <div class="listing-row-content">
                                            <p><?php echo strWordCut($term->description,250);?></p>
                                        </div>
                                    </div>
                                </div>

                        <?php    }
                                
                        }

                        if( !empty($programy) ) {
                            $args = array(
                                'post_type' => 'program',
                                'post__in' => $programy
                            );
                            $the_query = new WP_Query( $args );
                            if ( $the_query->have_posts() ) {
                                echo '<div class="document-title"><h1>Programy</h1></div>';
                                while ( $the_query->have_posts() ) {
                                    $the_query->the_post();
                                    get_template_part( 'templates/listings/row' );
                                }
                                wp_reset_postdata();
                            }
                        }
                    ?>

                    </div><!-- /.content -->

            <?php dynamic_sidebar( 'content-bottom' ); ?>

        </div><!-- #primary -->
    </div><!-- /.col-* -->

    <?php get_sidebar() ?>
</div><!-- /.row -->

<?php get_footer(); ?>
