<?php
/**
 * The template for displaying primary sidebar
 *
 * @package Superlist
 * @since Superlist 1.0.0
 */
$program = get_page_by_path($post->post_name,OBJECT,'program');
?>

<?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?>
    <div class="col-sm-4 col-lg-3">
        <div id="secondary" class="secondary sidebar">
        	<div id="sticky">
	            <?php dynamic_sidebar( 'sidebar-1' ); ?>
                <?php if( is_singular('program') ) {?>
	            <div id="categories-8" class="widget widget_categories">
	                <h2 class="widgettitle">Porównaj <?php echo $post->post_title;?> z...</h2>
	                <?php 
                        $custom_terms = wp_get_post_terms($program->ID, 'listing_categories');
                        $tax_query = array();

                        if( count( $custom_terms ) > 1 )
                            $tax_query['relation'] = 'OR' ;

                        foreach( $custom_terms as $custom_term ) {
                            $tax_query[] = array(
                                'taxonomy' => 'listing_categories',
                                'field' => 'slug',
                                'terms' => $custom_term->slug,
                            );
                        };

                        $term_list = wp_get_post_terms($program->ID, 'listing_categories', array("fields" => "ids"));
                        $args = array( 
                            'posts_per_page'  => 6, 
                            'post__not_in' => array( $program->ID),
                            'post_type' => 'program',
                            'tax_query' => array(
                                array(
                                    'taxonomy' => 'listing_categories',
                                    'field'    => 'term_id',
                                    'terms'    => $term_list,
                                    'operator' => 'IN',
                                ),
                            ),
                            'orderby' => array( 
                                'meta_value_num' => 'DESC', 
                               'title'      => 'ASC', 
                               
                            ), 
                            'meta_key' => 'inventor_reviews_post_total_rating',
                            'order' => 'DESC'
                        );

                        $loop = new WP_Query($args);

                        if( $loop->have_posts() ) {
                            echo '<ul id="comapreWith">';
                            while( $loop->have_posts() ) : $loop->the_post();
                                $logo = get_post_meta($post->ID, 'listing_logo', true);
                                echo '<li><a href="'.get_bloginfo('url').'/porownaj/'.$program->post_name.'-vs-'.$post->post_name.'"><img src="'.$logo.'">'.$program->post_title.' vs '.get_the_title().'</a></li>';
                            endwhile;
                            echo '</ul>';
                        }
                        wp_reset_query();
                    ?>
	                <a href="<?php echo get_the_permalink(8286);?><?php echo get_post_field( 'post_name', $post->ID ); ?>" class="view-all-alt">Zobacz więcej alternatyw</a>
	            </div>
                <?php } ?>
	        </div>
        </div><!-- /#secondary -->
    </div><!-- /.col-* -->
<?php endif; ?>
