<?php global $wp_query; ?>
<?php $query = $wp_query; ?>
<?php 
    $cena = array(
        'Cena' => array(

        )
    );
    
    foreach ( $query->posts as $post ) {
        $price = Inventor_Price::get_price( $post->ID );
        $price = empty( $price ) ? '' : $price;
        $special_label = apply_filters( 'inventor_listing_special_label', $price, $post->ID, 'column' );


        $cena['Cena'][$post->ID] = $special_label;
    }

    $compare_data = array_slice($compare_data, 0, 1, true) + $cena + array_slice($compare_data, 1, count($compare_data) - 1, true);
?>

<?php if ( $query->post_count > 0 ) : ?>
    <div class="compare-wrapper">
        <div id="compare-sticky-header">
            <table class="compare-table">
            <thead>
                <tr>
                    <th></th>

                    <?php foreach ( $query->posts as $post ): ?>
                    <th rel="compare-listing-<?php echo $post->ID; ?>">
                        <?php $logo = get_post_meta($post->ID, 'listing_logo', true);?>
                        <?php if ( $logo ) : ?>
                            <?php $image = $logo; ?>
                        <?php else: ?>
                            <?php $image = esc_attr( plugins_url( 'inventor' ) ) . '/assets/img/default-item.png'; ?>
                        <?php endif; ?>

                        <?php $featured = get_post_meta( $post->ID, INVENTOR_LISTING_PREFIX . 'featured', true ); ?>
                        <?php $reduced = get_post_meta( $post->ID, INVENTOR_LISTING_PREFIX . 'reduced', true ); ?>

                        <?php if ( $featured ) : ?>
                            <div class="compare-table-label-top compare-table-label-top-left"><?php echo esc_attr__( 'Featured', 'inventor' ); ?></div><!-- /.compare-table-label-top-left -->
                        <?php endif; ?>

                        <?php if ( $reduced ) : ?>
                            <div class="compare-table-label-top compare-table-label-top-right"><?php echo esc_attr__( 'Reduced', 'inventor' ); ?></div><!-- /.compare-table-label-top-right -->
                        <?php endif; ?>

                        <div class="compare-sticky-row">
                            <img src="<?php echo esc_attr( $image ); ?>">
                            <div class="compare-table-title">
                                <h3><a href="<?php echo get_the_permalink( $post->ID ); ?>"><?php echo get_the_title( $post->ID ); ?></a></h3>

                                <?php $location = Inventor_Query::get_listing_location_name( $post->ID, '/', false ); ?>
                                <?php $subtitle = apply_filters( 'inventor_listing_subtitle', $location, $post->ID, 'column' ); ?>
                                <?php if ( ! empty( $subtitle ) ): ?>
                                    <span class="compare-table-subtitle"><?php echo $subtitle; ?></span>
                                <?php endif; ?>

                                <?php $rating = get_post_meta( $post->ID, INVENTOR_REVIEWS_TOTAL_RATING_META, true ); ?>
                                <?php $rating = empty ( $rating ) ? 0 : $rating; ?>
                                <?php $reviews_count = get_comment_count( $post->ID ); ?>

                                <span class="review-rating" <?php do_action( 'inventor_review_rating_total_attrs', $post->ID ); ?> data-path="<?php echo plugins_url(); ?>/inventor-reviews/libraries/raty/images" data-score="<?php echo esc_attr( $rating ); ?>" ></span>
                                
                                <?php 
                                    if( $reviews_count['approved'] == 1 ) {
                                        echo '1 opinia';
                                    } else if($reviews_count['approved'] % 10 >= 2 && $reviews_count['approved'] % 10 <= 4 && ($reviews_count['approved'] % 100 < 10 || $reviews_count['approved'] % 100 >= 20)) {
                                        echo $reviews_count['approved'].' opinie';
                                    } else {
                                        echo $reviews_count['approved'].' opinii';
                                    }
                                ?>
                            </div>
                        </div>
                        
                    </th>
                    <?php endforeach; ?>

                </tr>
            </thead>
        </table>
        </div>
        <table class="compare-table">
            <thead>
                <tr>
                    <th></th>

                    <?php foreach ( $query->posts as $post ): ?>
                    <th rel="compare-listing-<?php echo $post->ID; ?>">
                        <?php $logo = get_post_meta($post->ID, 'listing_logo', true);?>
                        <?php if ( $logo ) : ?>
                            <?php $image = $logo; ?>
                        <?php else: ?>
                            <?php $image = esc_attr( plugins_url( 'inventor' ) ) . '/assets/img/default-item.png'; ?>
                        <?php endif; ?>

                        <div class="compare-table-image" style="background-image: url('<?php echo esc_attr( $image ); ?>');">
                            <a href="#" class="inventor-compare-btn-remove" data-listing-id="<?php echo $post->ID; ?>" data-ajax-url="<?php echo admin_url( 'admin-ajax.php' ); ?>">
                                <i class="fa fa-times"></i><?php echo __( 'Remove from comparison', 'inventor-compare' ); ?>
                            </a><!-- /.inventor-compare-btn-remove -->
                        </div><!-- /.compare-table-image-->

                        <?php $featured = get_post_meta( $post->ID, INVENTOR_LISTING_PREFIX . 'featured', true ); ?>
                        <?php $reduced = get_post_meta( $post->ID, INVENTOR_LISTING_PREFIX . 'reduced', true ); ?>

                        <?php if ( $featured ) : ?>
                            <div class="compare-table-label-top compare-table-label-top-left"><?php echo esc_attr__( 'Featured', 'inventor' ); ?></div><!-- /.compare-table-label-top-left -->
                        <?php endif; ?>

                        <?php if ( $reduced ) : ?>
                            <div class="compare-table-label-top compare-table-label-top-right"><?php echo esc_attr__( 'Reduced', 'inventor' ); ?></div><!-- /.compare-table-label-top-right -->
                        <?php endif; ?>

                        <div class="compare-table-title">
                            <h3><a href="<?php echo get_the_permalink( $post->ID ); ?>"><?php echo get_the_title( $post->ID ); ?></a></h3>

                            <?php $location = Inventor_Query::get_listing_location_name( $post->ID, '/', false ); ?>
                            <?php $subtitle = apply_filters( 'inventor_listing_subtitle', $location, $post->ID, 'column' ); ?>
                            <?php if ( ! empty( $subtitle ) ): ?>
                                <span class="compare-table-subtitle"><?php echo $subtitle; ?></span>
                            <?php endif; ?>

                            <?php $rating = get_post_meta( $post->ID, INVENTOR_REVIEWS_TOTAL_RATING_META, true ); ?>
                            <?php $rating = empty ( $rating ) ? 0 : $rating; ?>
                            <?php $reviews_count = get_comment_count( $post->ID ); ?>

                            <span class="review-rating" <?php do_action( 'inventor_review_rating_total_attrs', $post->ID ); ?> data-path="<?php echo plugins_url(); ?>/inventor-reviews/libraries/raty/images" data-score="<?php echo esc_attr( $rating ); ?>" ></span>
                            
                            <?php 
                                if( $reviews_count['approved'] == 1 ) {
                                    echo '1 opinia';
                                } else if($reviews_count['approved'] % 10 >= 2 && $reviews_count['approved'] % 10 <= 4 && ($reviews_count['approved'] % 100 < 10 || $reviews_count['approved'] % 100 >= 20)) {
                                    echo $reviews_count['approved'].' opinie';
                                } else {
                                    echo $reviews_count['approved'].' opinii';
                                }
                            ?>
                        </div><!-- /.compare-table-title -->
                    </th>
                    <?php endforeach; ?>

                </tr>
            </thead>

            <tbody>
                <tr>
                    <td><h3>Informacje ogólne</h3></td>
                </tr>
                <tr>
                    <td class="compare-table-label"><?php echo __( 'Strona programu', 'inventor-compare' ); ?></td>
                    <?php foreach ( $query->posts as $post ) : ?>
                        <?php $listing_type = Inventor_Post_Types::get_listing_type_name( $post->ID ); ?>
                        <?php $icon = Inventor_Post_Type_Listing::get_icon( $post->ID, true ); ?>
                        <td class="compare-table-col" rel="compare-listing-<?php echo $post->ID; ?>">
                            <p class="text-center"><a href="<?php echo get_post_meta($post->ID, 'listing_website', true);?>" class="btn btn-blue" target="_blank">Zobacz stronę</a></p>
                        </td>
                    <?php endforeach; ?>
                </tr>

                <tr>
                    <td class="compare-table-label"><?php echo __( 'Slogan', 'inventor-compare' ); ?></td>
                    <?php foreach ( $query->posts as $post ) : ?>
                        <td class="compare-table-col" rel="compare-listing-<?php echo $post->ID; ?>">
                            <p class="text-center"><?php echo get_post_meta($post->ID, 'listing_slogan', true);?></p>
                        </td>
                    <?php endforeach; ?>
                </tr>

                <?php foreach( $compare_data as $field_name => $attributes ): ?>
                <tr>
                    <td class="compare-table-label"><?php echo $field_name; ?></td>
                    <?php foreach ( $query->posts as $post ) : ?>
                        <?php $attribute = isset( $attributes[ $post->ID ] ) ? $attributes[ $post->ID ] : null; ?>
                        <td class="compare-table-col" rel="compare-listing-<?php echo $post->ID; ?>">
                            <span class="compare-table-col-label"><?php echo $field_name; ?></span>
                            <?php echo ! empty( $attribute ) ? $attribute : '-'; ?>
                        </td>
                    <?php endforeach; ?>
                </tr>
                <?php endforeach; ?>
            </tbody>
            <?php 
                $categories = array();
                foreach ( $query->posts as $post ) {
                    $term_list = wp_get_post_terms($post->ID, 'listing_categories', array("fields" => "ids"));
                    $categories = array_unique(array_merge($categories,$term_list), SORT_REGULAR);
                }

                $array = [];

                foreach ( $query->posts as $post ) {
                    $funkcjonalnosci = wp_get_post_terms($post->ID, 'funkcjonalnosci');

                    foreach($funkcjonalnosci as $funkcjonalnosc) {
                      $kategoria = get_field('kategoria', 'funkcjonalnosci_'.$funkcjonalnosc->term_id);
                      $array[$post->ID][$kategoria][] = $funkcjonalnosc->term_id;
                    }
                }

            ?>
            <tbody>
                <tr>
                    <td colspan="<?php echo $query->post_count;?>"><h3>Zrzuty ekranu</h3></td>
                </tr>
                <tr>
                    <td></td>
                    <?php foreach ( $query->posts as $post ) : ?>
                        <?php 
                        $galleries = get_post_meta( $post->ID, 'listing_gallery', true );
                        $first_key = key($galleries);
                        $src = wp_get_attachment_image_src($first_key, 'compare');
                        $full = wp_get_attachment_image_src($first_key, '');
                        if (count($galleries) === 1) {
                            $odmiana = 'screen';
                        } else if (count($galleries) % 10 >= 2 && count($galleries) % 10 <= 4 && (count($galleries) % 100 < 10 || count($galleries) % 100 >= 20)) {
                            $odmiana = 'screeny';
                        } else {
                            $odmiana = 'screenów';
                        }

                        $gal = '';

                        foreach( array_slice($galleries,1) as $id=>$url) {
                            $gal .= '<a href="'.$url.'" rel="compare-gallery-'.$post->ID.'"></a>';
                        }
                        echo '<td class="compare-image"><a href="'.$full[0].'" rel="compare-gallery-'.$post->ID.'"><img src="'.$src[0].'"><span>Zobacz '.count($galleries).' '.$odmiana.' '.$post->post_title.'</a>'.$gal.'</span></td>';


                        ?>
                    <?php endforeach;?>
                </tr>
            </tbody>
            <?php 
                $i = 0;
                $len = count($categories);
                foreach($categories as $cat) {
                $category = get_term_by('id', $cat, 'listing_categories');

                $list = array();
                foreach($array as $post) {
                    if( isset($post[$cat])) {
                        $list = array_unique(array_merge($list,$post[$cat]), SORT_REGULAR);
                    }
                }

            ?>
            <tbody>
                <tr>
                    <td colspan="<?php echo $query->post_count;?>"><h3>Funkcjonalności <?php echo $category->name;?></h3></td>
                </tr>
                <?php foreach($list as $lis) { $term = get_term_by('id', $lis, 'funkcjonalnosci'); ?>
                <tr>
                    <td class="compare-table-label"><?php echo $term->name; ?></td>
                    <?php foreach ( $query->posts as $post ) { ?>
                        <td class="function-cell">
                        <span class="compare-table-col-label"><?php echo $term->name; ?></span>
                        <?php if( has_term( $term->term_id, 'funkcjonalnosci', $post->ID ) ) echo '<img src="'.get_bloginfo('template_directory').'/assets/img/full.png">'; else echo '<img src="'.get_bloginfo('template_directory').'/assets/img/empty.png">'; ?>
                        </td>
                    <?php } ?>
                </tr>
                <?php } ?>
                <?php if ($i == $len - 1) { ?>
                <tr>
                    <td class="compare-table-label"><?php echo __( 'Strona programu', 'inventor-compare' ); ?></td>
                    <?php foreach ( $query->posts as $post ) : ?>
                        <?php $listing_type = Inventor_Post_Types::get_listing_type_name( $post->ID ); ?>
                        <?php $icon = Inventor_Post_Type_Listing::get_icon( $post->ID, true ); ?>
                        <td class="compare-table-col" rel="compare-listing-<?php echo $post->ID; ?>">
                            <p class="text-center"><a href="<?php echo get_post_meta($post->ID, 'listing_website', true);?>" class="btn btn-blue footer-btn" target="_blank">Zobacz stronę</a></p>
                        </td>
                    <?php endforeach; ?>
                </tr>
                <?php } ?>
            </tbody>
            <?php $i++; } ?>
            <tfoot>
                <tr>
                    <th></th>

                    <?php foreach ( $query->posts as $post ): ?>
                    <th rel="compare-listing-<?php echo $post->ID; ?>">
                        <div class="compare-table-title">
                            <h3><a href="<?php echo get_the_permalink( $post->ID ); ?>"><?php echo get_the_title( $post->ID ); ?></a></h3>

                            <?php $location = Inventor_Query::get_listing_location_name( $post->ID, '/', false ); ?>
                            <?php $subtitle = apply_filters( 'inventor_listing_subtitle', $location, $post->ID, 'column' ); ?>
                            <?php if ( ! empty( $subtitle ) ): ?>
                                <span class="compare-table-subtitle"><?php echo $subtitle; ?></span>
                            <?php endif; ?>

                            <?php $rating = get_post_meta( $post->ID, INVENTOR_REVIEWS_TOTAL_RATING_META, true ); ?>
                            <?php $rating = empty ( $rating ) ? 0 : $rating; ?>
                            <?php $reviews_count = get_comment_count( $post->ID ); ?>

                            <span class="review-rating" <?php do_action( 'inventor_review_rating_total_attrs', $post->ID ); ?> data-path="<?php echo plugins_url(); ?>/inventor-reviews/libraries/raty/images" data-score="<?php echo esc_attr( $rating ); ?>" ></span>
                            
                            <?php 
                                if( $reviews_count['approved'] == 1 ) {
                                    echo '1 opinia';
                                } else if($reviews_count['approved'] % 10 >= 2 && $reviews_count['approved'] % 10 <= 4 && ($reviews_count['approved'] % 100 < 10 || $reviews_count['approved'] % 100 >= 20)) {
                                    echo $reviews_count['approved'].' opinie';
                                } else {
                                    echo $reviews_count['approved'].' opinii';
                                }
                            ?>
                        </div><!-- /.compare-table-title -->
                    </th>
                    <?php endforeach; ?>

                </tr>
            </tfoot>
        </table>
    </div><!-- /.compare-wrapper -->
<?php else : ?>
    <div class="alert alert-info">
        <?php echo __( 'Nothing to compare.', 'inventor-compare' ); ?>
    </div>
<?php endif; ?>
