<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
$current_id = get_the_ID();

if( isset($_GET['id']) ) {
    $program = $_GET['id'];
    $queried_post = get_page_by_path($program,OBJECT,'program');
    $program_id = $queried_post->ID;
} else {
    $program_id = $current_id;
}

?>

<?php $instance['per_row'] = empty( $instance['per_row'] ) ? 3 : $instance['per_row']; ?>
<?php $instance['per_row'] = $instance['display'] == 'carousel' ? 1 : $instance['per_row']; ?>
<?php $instance['hide_pagination'] = isset( $instance['hide_pagination'] ) ? $instance['hide_pagination'] : true; ?>

<?php echo wp_kses( $args['before_widget'], wp_kses_allowed_html( 'post' ) ); ?>

    <div id="listing-detail-section-<?php echo sanitize_title($instance['title']);?>" class="listing-detail-section widget-inner
 <?php if ( ! empty( $instance['classes'] ) ) : ?><?php echo esc_attr( $instance['classes'] ); ?><?php endif; ?>
 <?php echo ( empty( $instance['padding_top'] ) ) ? '' : 'widget-pt' ; ?>
 <?php echo ( empty( $instance['padding_bottom'] ) ) ? '' : 'widget-pb' ; ?>"
        <?php if ( ! empty( $instance['background_color'] ) || ! empty( $instance['background_image'] ) ) : ?>
            style="
            <?php if ( ! empty( $instance['background_color'] ) ) : ?>
                background-color: <?php echo esc_attr( $instance['background_color'] ); ?>;
    <?php endif; ?>
            <?php if ( ! empty( $instance['background_image'] ) ) : ?>
                background-image: url('<?php echo esc_attr( $instance['background_image'] ); ?>');
            <?php endif; ?>"
        <?php endif; ?>>

        <?php if ( ! empty( $instance['title'] ) ) : ?>
            <?php echo wp_kses( $args['before_title'], wp_kses_allowed_html( 'post' ) ); ?>
            <?php echo wp_kses( $instance['title'], wp_kses_allowed_html( 'post' ) ); ?>
            <?php echo wp_kses( $args['after_title'], wp_kses_allowed_html( 'post' ) ); ?>
        <?php endif; ?>

        <?php 
            $term_list = wp_get_post_terms($program_id, 'listing_categories', array("fields" => "ids"));
            $argsy = array( 
                'posts_per_page'  => $instance['count'], 
                'post__not_in' => array( $program_id ),
                'post_type' => 'program',
                'tax_query' => array(
                    array(
                        'taxonomy' => 'listing_categories',
                        'field'    => 'term_id',
                        'terms'    => $term_list,
                        'operator' => 'IN',
                    ),
                ),
                'orderby' => array( 
                    'meta_value_num' => 'DESC', 
                   'title'      => 'ASC', 
                   
                ), 
                'meta_key' => 'inventor_reviews_post_total_rating',
                'order' => 'DESC'
            );
            $the_query = new WP_Query( $argsy );
        ?>

        <?php if ( $the_query->have_posts() ) : ?>
            <?php if ( ! empty( $instance['description'] ) ) : ?>
                <div class="description">
                    <?php echo wp_kses( $instance['description'], wp_kses_allowed_html( 'post' ) ); ?>
                </div><!-- /.description -->
            <?php endif; ?>

            <div class="type-<?php echo esc_attr( $instance['display'] ); ?> items-per-row-<?php echo esc_attr( $instance['per_row'] ); ?>">

                <?php if ( 'masonry' == $instance['display'] ) : ?>

                    <div class="listings-row">
                        <?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
                            <div class="listing-masonry-container">
                                <?php include Inventor_Template_Loader::locate( 'listings/' . $instance['display'] ); ?>
                            </div><!-- /.listing-masonry-container -->
                        <?php endwhile; ?>
                    </div><!-- /.listing-row -->

                <?php elseif ( 'carousel' == $instance['display'] ) : ?>

                    <div class="listing-carousel">
                        <?php while ( have_posts() ) : the_post(); ?>
                            <div class="listing-container">
                                <?php include Inventor_Template_Loader::locate( 'listings/column' ); ?>
                            </div><!-- /.listing-container -->
                        <?php endwhile; ?>
                    </div><!-- /.listing-row -->

                <?php else : ?>

                    <div class="listings-row">

                        <?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
                            <div class="listing-container">
                                <?php include Inventor_Template_Loader::locate( 'listings/' . $instance['display'] ); ?>
                            </div><!-- /.listing-container -->
                        <?php endwhile; ?>

                    </div><!-- /.listing-row -->

                <?php endif; ?>

            </div><!-- /.type-* -->

            <?php if ( ! $instance['hide_pagination'] ): ?>
                <?php the_posts_pagination( array(
                    'prev_text'             => __( 'Previous', 'inventor' ),
                    'next_text'             => __( 'Next', 'inventor' ),
                    'mid_size'              => 2,
                ) ); ?>
            <?php endif; ?>
        <?php else : ?>
            <div class="alert alert-warning">
                <?php echo __( 'No listings found.', 'inventor' ); ?>
            </div><!-- /.alert -->
        <?php endif; ?>
        <?php if( !isset($_GET['id']) ) {?>
        <div class="view_all">
            <a class="btn btn-primary" href="<?php echo get_the_permalink(8286);?><?php echo get_post_field( 'post_name', $current_id ); ?>">Zobacz wszystkie alternatywy</a>
        </div>
        <?php } ?>
    </div><!-- /.widget-inner -->

<?php echo wp_kses( $args['after_widget'], wp_kses_allowed_html( 'post' ) ); ?>